/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.utility.data.auth;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.concurrent.TimeUnit;
import org.alfresco.utility.TasProperties;
import org.alfresco.utility.Utility;
import org.alfresco.utility.report.log.Step;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.Platform;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;

@Service
@Scope(value="prototype")
public class DataNtlmPassthru {
    @Autowired
    private TasProperties tasProperties;
    private String command;
    private String psCommand;
    String userPrefPath = "C:\\Program Files\\Mozilla Firefox\\defaults\\pref";
    String userPrefFile = "userPref.js";
    String firefoxPath = "C:\\Program Files\\Mozilla Firefox";
    String hub = "http://ec2-34-253-204-163.eu-west-1.compute.amazonaws.com:8070";

    public Builder perform() {
        return new Builder();
    }

    private WebDriver setDriver() throws MalformedURLException {
        DesiredCapabilities cap = DesiredCapabilities.firefox();
        cap.setBrowserName("firefox");
        cap.setPlatform(Platform.WIN8);
        cap.setCapability("marionette", true);
        cap.setCapability("network.automatic-ntlm-auth.trusted-uris", this.tasProperties.getTestServerUrl());
        RemoteWebDriver driver = new RemoteWebDriver(new URL(String.format("%s/wd/hub", this.hub)), (Capabilities)cap);
        driver.manage().timeouts().implicitlyWait(10L, TimeUnit.SECONDS);
        driver.manage().timeouts().pageLoadTimeout(30L, TimeUnit.SECONDS);
        return driver;
    }

    public String getTitleInFirefox(String url) throws MalformedURLException {
        Step.STEP(String.format("Open URL %s", url));
        WebDriver driver = this.setDriver();
        driver.get(url);
        String title = driver.getTitle();
        driver.quit();
        return title;
    }

    public String getAlertInFirefox(String url) throws MalformedURLException {
        WebDriver driver = this.setDriver();
        Step.STEP(String.format("Open URL %s", url));
        driver.get(url);
        String alertText = driver.switchTo().alert().getText();
        driver.quit();
        return alertText;
    }

    public class Builder {
        public Builder() {
            DataNtlmPassthru.this.psCommand = String.format("psexec \\\\%s -u %s -p %s", DataNtlmPassthru.this.tasProperties.getNtlmHost(), DataNtlmPassthru.this.tasProperties.getNtlmSecurityPrincipal(), DataNtlmPassthru.this.tasProperties.getNtlmSecurityCredentials());
        }

        public Builder configureFirefox() throws Exception {
            Step.STEP(String.format("[NTLM] Add alfresco ip address %s to network.automatic-ntlm-auth.trusted-uris", DataNtlmPassthru.this.tasProperties.getTestServerUrl()));
            DataNtlmPassthru.this.command = String.format("%s cmd /C \"cd \"%s\" && echo pref(\"network.automatic-ntlm-auth.trusted-uris\", \"%s\");pref(\"general.config.filename\", \"mozilla.cfg\");  > %s\"", DataNtlmPassthru.this.psCommand, DataNtlmPassthru.this.userPrefPath, DataNtlmPassthru.this.tasProperties.getTestServerUrl(), DataNtlmPassthru.this.userPrefFile);
            Step.STEP(Utility.executeOnWinAndReturnOutput(DataNtlmPassthru.this.command));
            DataNtlmPassthru.this.command = String.format("%s cmd /C \"cd \"%s\" && echo lockPref(\"browser.shell.checkDefaultBrowser\", false); > mozilla.cfg\"", DataNtlmPassthru.this.psCommand, DataNtlmPassthru.this.firefoxPath);
            Step.STEP(Utility.executeOnWinAndReturnOutput(DataNtlmPassthru.this.command));
            return this;
        }
    }
}

