/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.utility.data.auth;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.alfresco.utility.TasProperties;
import org.alfresco.utility.data.auth.UserManageable;
import org.alfresco.utility.model.UserModel;
import org.alfresco.utility.report.log.Step;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;
import org.testng.Assert;

@Service
@Scope(value="prototype")
public class DataOracleDirectoryServer {
    @Autowired
    private TasProperties tasProperties;
    private static final String USER_SEARCH_BASE = "cn=%s,ou=People,dc=alfness,dc=com";
    private DirContext context;

    public Builder perform() throws NamingException {
        return new Builder();
    }

    public class Builder
    implements UserManageable {
        public Builder() throws NamingException {
            Properties properties = new Properties();
            properties.put("java.naming.factory.initial", DataOracleDirectoryServer.this.tasProperties.getAuthContextFactory());
            properties.put("java.naming.provider.url", DataOracleDirectoryServer.this.tasProperties.getOracleURL());
            properties.put("java.naming.security.authentication", DataOracleDirectoryServer.this.tasProperties.getSecurityAuth());
            properties.put("java.naming.security.principal", DataOracleDirectoryServer.this.tasProperties.getOracleSecurityPrincipal());
            properties.put("java.naming.security.credentials", DataOracleDirectoryServer.this.tasProperties.getOracleSecurityCredentials());
            DataOracleDirectoryServer.this.context = new InitialDirContext(properties);
        }

        @Override
        public UserManageable createUser(UserModel user) throws NamingException {
            Step.STEP(String.format("[OracleDirServer] Add user %s", user.getUsername()));
            BasicAttributes attributes = new BasicAttributes();
            BasicAttribute objectClass = new BasicAttribute("objectClass");
            BasicAttribute sn = new BasicAttribute("sn");
            BasicAttribute userPassword = new BasicAttribute("userPassword");
            objectClass.add("inetOrgPerson");
            sn.add(user.getLastName());
            userPassword.add(user.getPassword());
            attributes.put(objectClass);
            attributes.put(sn);
            attributes.put(userPassword);
            DataOracleDirectoryServer.this.context.createSubcontext(String.format(DataOracleDirectoryServer.USER_SEARCH_BASE, user.getUsername()), (Attributes)attributes);
            return this;
        }

        @Override
        public UserManageable deleteUser(UserModel user) throws NamingException {
            Step.STEP(String.format("[OracleDirServer] Delete user %s", user.getUsername()));
            DataOracleDirectoryServer.this.context.destroySubcontext(String.format(DataOracleDirectoryServer.USER_SEARCH_BASE, user.getUsername()));
            return this;
        }

        @Override
        public UserManageable updateUser(UserModel user, HashMap<String, String> attributes) throws NamingException {
            Step.STEP(String.format("[OracleDirServer] Update user %s", user.getUsername()));
            ModificationItem[] items = new ModificationItem[attributes.size()];
            int i = 0;
            for (Map.Entry<String, String> entry : attributes.entrySet()) {
                BasicAttribute attribute = new BasicAttribute(entry.getKey(), entry.getValue());
                items[i] = new ModificationItem(2, attribute);
                ++i;
            }
            DataOracleDirectoryServer.this.context.modifyAttributes(String.format(DataOracleDirectoryServer.USER_SEARCH_BASE, user.getUsername()), items);
            return this;
        }

        public SearchResult searchForObjectClass(String name, String typeOfClass, String base) throws NamingException {
            NamingEnumeration<SearchResult> results = null;
            String searchFilter = String.format("(objectClass=%s)", typeOfClass.toString());
            SearchControls searchControls = new SearchControls();
            searchControls.setSearchScope(2);
            try {
                results = DataOracleDirectoryServer.this.context.search(String.format(base, name), searchFilter, searchControls);
            }
            catch (NameNotFoundException e) {
                return null;
            }
            if (results.hasMoreElements()) {
                return (SearchResult)results.nextElement();
            }
            return null;
        }

        @Override
        public UserManageable assertUserExists(UserModel user) throws NamingException {
            Step.STEP(String.format("[OracleDirServer] Assert user %s exists", user.getUsername()));
            Assert.assertNotNull((Object)this.searchForObjectClass(user.getUsername(), "inetOrgPerson", DataOracleDirectoryServer.USER_SEARCH_BASE));
            return this;
        }

        @Override
        public UserManageable assertUserDoesNotExist(UserModel user) throws NamingException {
            Step.STEP(String.format("[OracleDirServer] Assert user %s does not exist", user.getUsername()));
            Assert.assertNull((Object)this.searchForObjectClass(user.getUsername(), "inetOrgPerson", DataOracleDirectoryServer.USER_SEARCH_BASE));
            return this;
        }
    }
}

