/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.utility.extension;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.alfresco.utility.exception.TestCaseNotFoundException;
import org.alfresco.utility.exception.XMLToModelUnmarshalException;
import org.alfresco.utility.extension.ExtensionPointTestSuite;
import org.alfresco.utility.report.log.Step;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;
import org.testng.Assert;
import org.xml.sax.SAXException;

@Service
@Scope(value="prototype")
public class ExtentionPointTestUtility {
    static Logger LOGGER = LoggerFactory.getLogger(ExtentionPointTestUtility.class);

    public ExtensionPointTestSuite xmlToClass(InputStream importFileXML) throws JAXBException {
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{ExtensionPointTestSuite.class});
        Unmarshaller um = context.createUnmarshaller();
        ExtensionPointTestSuite webScriptController = (ExtensionPointTestSuite)um.unmarshal(importFileXML);
        return webScriptController;
    }

    public void validateAgainstXSD(InputStream importFileXML) throws IOException, XMLToModelUnmarshalException {
        try {
            SchemaFactory factory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            Schema schema = factory.newSchema(new StreamSource(this.getWebScriptXSDSchemaFile()));
            Validator validator = schema.newValidator();
            validator.validate(new StreamSource(importFileXML));
        }
        catch (SAXException ex) {
            throw new XMLToModelUnmarshalException(ExtentionPointTestUtility.class, ex);
        }
    }

    private File getWebScriptXSDSchemaFile() {
        ClassLoader classLoader = this.getClass().getClassLoader();
        File schemaFile = new File(classLoader.getResource("shared-resources/testdata/extentionPointTestSuiteTemplate.xsd").getFile());
        return schemaFile;
    }

    public void assertTestCaseExecutionStatus(InputStream inputExtension, String testCaseName) throws JAXBException, TestCaseNotFoundException {
        ExtensionPointTestSuite extensionPointTestSuite = this.xmlToClass(inputExtension);
        if (extensionPointTestSuite.getTestCases() != null && extensionPointTestSuite.getTestCases().getTestcase().size() > 0) {
            for (ExtensionPointTestSuite.TestCases.Testcase testcase : extensionPointTestSuite.getTestCases().getTestcase()) {
                if (testcase.getName() == null || !testcase.getName().equals(testCaseName)) continue;
                Step.STEP("ExtensionPoint: Verify that '" + String.valueOf(testcase.getClass()) + "." + testcase.getName() + "' PASS");
                Assert.assertEquals((String)testcase.getActualValue(), (String)testcase.getExpectedValue(), (String)String.format("Method [%s] was executed successfully. Stack trace: %s", testcase.getName(), testcase.getStackTrace()));
                return;
            }
            throw new TestCaseNotFoundException(testCaseName);
        }
    }
}

