/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.utility.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import javax.xml.bind.annotation.XmlAttribute;
import org.alfresco.dataprep.SiteService;
import org.alfresco.utility.Utility;
import org.alfresco.utility.data.RandomData;
import org.alfresco.utility.model.TestModel;

public class SiteModel
extends TestModel {
    @JsonProperty(required=true)
    protected SiteService.Visibility visibility;
    @JsonProperty(required=true)
    protected String guid;
    @JsonProperty(required=true)
    protected String id;
    @JsonProperty(required=true)
    protected String title;
    protected String description;

    public SiteModel() {
    }

    public SiteModel(String title) {
        this(title, SiteService.Visibility.PUBLIC);
    }

    public SiteModel(String title, SiteService.Visibility visibility) {
        this.visibility = visibility;
        this.setTitle(title);
        this.setId(title);
        this.setDescription(String.format("%s%s", title, visibility));
    }

    public SiteModel(SiteService.Visibility visibility, String guid, String id, String title, String description) {
        this.visibility = visibility;
        this.guid = guid;
        this.id = id;
        this.title = title;
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @XmlAttribute
    public SiteService.Visibility getVisibility() {
        return this.visibility;
    }

    public void setVisibility(SiteService.Visibility visibility) {
        this.visibility = visibility;
    }

    public String getGuid() {
        return this.guid;
    }

    public String getGuidWithoutVersion() {
        return Utility.splitGuidVersion(this.getGuid());
    }

    public void setGuid(String guid) {
        this.guid = guid;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public static SiteModel getRandomSiteModel() {
        String siteName = RandomData.getRandomName("site");
        LOG.info("Generating new random Site Model: {}", (Object)siteName);
        return new SiteModel(siteName);
    }
}

