/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.utility.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Date;
import org.alfresco.dataprep.CMISUtil;
import org.alfresco.utility.data.RandomData;
import org.alfresco.utility.model.TestModel;
import org.joda.time.DateTime;

public class TaskModel
extends TestModel {
    @JsonProperty(required=true)
    private String id;
    @JsonProperty(value="description")
    private String message;
    @JsonProperty(value="dueAt")
    private Date dueDate;
    private String assignee;
    private CMISUtil.Priority priority;
    private Boolean sendEmail;
    private String processId;

    public TaskModel() {
    }

    public TaskModel(String assignee) {
        this.setAssignee(assignee);
        this.setMessage(RandomData.getRandomAlphanumeric());
        DateTime today = new DateTime();
        this.setDueDate(today.plusDays(2).toDate());
        this.setPriority(CMISUtil.Priority.High);
        this.setSendEmail(true);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public Date getDueDate() {
        return this.dueDate;
    }

    public void setDueDate(Date dueDate) {
        this.dueDate = dueDate;
    }

    public String getAssignee() {
        return this.assignee;
    }

    public void setAssignee(String assignee) {
        this.assignee = assignee;
    }

    public CMISUtil.Priority getPriority() {
        return this.priority;
    }

    public void setPriority(CMISUtil.Priority priority) {
        this.priority = priority;
    }

    public Boolean getSendEmail() {
        return this.sendEmail;
    }

    public void setSendEmail(Boolean sendEmail) {
        this.sendEmail = sendEmail;
    }

    public String getProcessId() {
        return this.processId;
    }

    public void setProcessId(String processId) {
        this.processId = processId;
    }
}

