/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.utility.testng;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.alfresco.utility.Utility;
import org.alfresco.utility.exception.TestConfigurationException;
import org.alfresco.utility.report.Bug;
import org.alfresco.utility.web.AbstractWebTest;
import org.alfresco.utility.web.browser.WebBrowser;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.SystemUtils;
import org.openqa.selenium.OutputType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.IInvokedMethod;
import org.testng.IInvokedMethodListener;
import org.testng.ITestResult;
import org.testng.SkipException;
import org.testng.annotations.Test;
import org.testng.internal.ConstructorOrMethod;

public class OSTestMethodSelector
implements IInvokedMethodListener {
    private WebBrowser browser;
    private static final Logger LOG = LoggerFactory.getLogger(OSTestMethodSelector.class);
    static Properties defaultProperties;

    public void beforeInvocation(IInvokedMethod testNGmethod, ITestResult testResult) {
        ConstructorOrMethod contructorOrMethod = testNGmethod.getTestMethod().getConstructorOrMethod();
        Method method = contructorOrMethod.getMethod();
        if (method != null && method.isAnnotationPresent(Test.class)) {
            List<String> groups;
            Test testClass = method.getAnnotation(Test.class);
            String runBugs = System.getProperty("runBugs");
            if ("false".equals(runBugs) && method.isAnnotationPresent(Bug.class)) {
                Bug bug = method.getAnnotation(Bug.class);
                switch (bug.status()) {
                    case FIXED: {
                        break;
                    }
                    case OPENED: {
                        throw new SkipException(String.format("This test is skipped because it is marked as OPENED BUG: {[id='%s', description='%s', status='%s']}.(info: you can run tests marked as opened bugs, passing -DrunBugs=true)", new Object[]{bug.id(), bug.description(), bug.status()}));
                    }
                    default: {
                        throw new IllegalArgumentException();
                    }
                }
            }
            if ((groups = Arrays.asList(testClass.groups())) != null && (groups.contains("linux") || groups.contains("windows") || groups.contains("mac"))) {
                if (SystemUtils.IS_OS_LINUX && !groups.contains("linux")) {
                    throw new SkipException(String.format("This test was skipped because it was marked to be executed on differed operating system(s). Groups used: %s and was executed on: %s", String.valueOf(groups), System.getProperty("os.name")));
                }
                if (SystemUtils.IS_OS_MAC && !groups.contains("mac")) {
                    throw new SkipException(String.format("This test was skipped because it was marked to be executed on differed operating system(s). Groups used: %s and was executed on: %s", String.valueOf(groups), System.getProperty("os.name")));
                }
                if (SystemUtils.IS_OS_WINDOWS && !groups.contains("windows")) {
                    throw new SkipException(String.format("This test was skipped because it was marked to be executed on differed operating system(s). Groups used: %s and was executed on: %s", String.valueOf(groups), System.getProperty("os.name")));
                }
            }
        }
    }

    public void afterInvocation(IInvokedMethod testNGmethod, ITestResult testResult) {
        if (!testResult.isSuccess() && testResult.getInstance() instanceof AbstractWebTest) {
            AbstractWebTest cfr_ignored_0 = (AbstractWebTest)((Object)testResult.getInstance());
            this.browser = AbstractWebTest.getBrowser();
            File screenshot = (File)this.browser.getScreenshotAs(OutputType.FILE);
            try {
                defaultProperties = Utility.getProperties(OSTestMethodSelector.class, Utility.getEnvironmentPropertyFile());
            }
            catch (TestConfigurationException e) {
                LOG.error("Could not get default properties: " + e.getMessage());
            }
            String screenshotsPath = defaultProperties.getProperty("reports.path") + File.separator + defaultProperties.getProperty("screenshots.dir");
            File saved = new File(screenshotsPath, testResult.getMethod().getMethodName() + ".png");
            try {
                FileUtils.copyFile((File)screenshot, (File)saved);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

