/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.utility.web.browser;

import org.openqa.selenium.By;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.support.events.WebDriverEventListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventWebBrowserListener
implements WebDriverEventListener {
    private static final Logger LOG = LoggerFactory.getLogger(EventWebBrowserListener.class);
    private String oldValue;

    public void beforeChangeValueOf(WebElement arg0, WebDriver arg1) {
        this.oldValue = arg0.getAttribute("value");
    }

    public void afterChangeValueOf(WebElement arg0, WebDriver arg1) {
        String elementName = this.getElementName(arg0);
        try {
            String newValue = arg0.getAttribute("value");
            if (!newValue.equals(this.oldValue)) {
                if (newValue.length() == 0) {
                    LOG.info("[{}] - cleared value", (Object)elementName);
                } else {
                    LOG.info("[{}] - changed value to '{}'", (Object)elementName, (Object)newValue);
                }
            }
        }
        catch (Exception e) {
            LOG.debug("[{}] - changed value", (Object)elementName);
        }
    }

    public void afterClickOn(WebElement arg0, WebDriver arg1) {
        LOG.info("Clicked on element '{}'", (Object)arg0);
    }

    public void afterFindBy(By arg0, WebElement arg1, WebDriver arg2) {
        LOG.debug("'{}' - found", (Object)arg0);
    }

    public void afterNavigateBack(WebDriver arg0) {
        LOG.info("Navigated Back");
    }

    public void afterNavigateForward(WebDriver arg0) {
        LOG.info("Navigated Forward");
    }

    public void afterNavigateTo(String arg0, WebDriver arg1) {
        LOG.info("Navigate to '{}'", (Object)arg0);
    }

    public void afterScript(String arg0, WebDriver arg1) {
        LOG.info("Ran script '{}'", (Object)arg0);
    }

    public void beforeSwitchToWindow(String s, WebDriver webDriver) {
    }

    public void afterSwitchToWindow(String s, WebDriver webDriver) {
    }

    public void beforeClickOn(WebElement arg0, WebDriver arg1) {
        LOG.debug("Trying to click '{}'", (Object)this.getElementName(arg0));
    }

    public void beforeFindBy(By arg0, WebElement arg1, WebDriver arg2) {
    }

    public void beforeNavigateBack(WebDriver arg0) {
    }

    public void beforeNavigateForward(WebDriver arg0) {
    }

    public void beforeNavigateTo(String arg0, WebDriver arg1) {
    }

    public void beforeScript(String arg0, WebDriver arg1) {
    }

    public void onException(Throwable arg0, WebDriver arg1) {
        LOG.error(arg0.getClass().getName(), arg0);
    }

    public <X> void beforeGetScreenshotAs(OutputType<X> outputType) {
    }

    public <X> void afterGetScreenshotAs(OutputType<X> outputType, X x) {
    }

    public void beforeGetText(WebElement webElement, WebDriver webDriver) {
    }

    public void afterGetText(WebElement webElement, WebDriver webDriver, String s) {
    }

    private String getElementName(WebElement arg0) {
        int arrowIndex;
        String foundBy = arg0.toString();
        if (foundBy != null && (arrowIndex = foundBy.indexOf("->")) >= 0) {
            return "By." + foundBy.substring(arrowIndex + 3, foundBy.length() - 1);
        }
        return "unknown";
    }

    public void beforeNavigateRefresh(WebDriver driver) {
    }

    public void afterNavigateRefresh(WebDriver driver) {
    }

    public void afterAlertAccept(WebDriver arg0) {
    }

    public void afterAlertDismiss(WebDriver arg0) {
    }

    public void afterChangeValueOf(WebElement arg0, WebDriver arg1, CharSequence[] arg2) {
    }

    public void beforeAlertAccept(WebDriver arg0) {
    }

    public void beforeAlertDismiss(WebDriver arg0) {
    }

    public void beforeChangeValueOf(WebElement arg0, WebDriver arg1, CharSequence[] arg2) {
    }
}

