/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.utility.web.browser;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.alfresco.utility.TasProperties;
import org.alfresco.utility.exception.PageOperationException;
import org.alfresco.utility.web.common.Parameter;
import org.apache.commons.httpclient.HttpState;
import org.openqa.selenium.Alert;
import org.openqa.selenium.By;
import org.openqa.selenium.Cookie;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.Keys;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.StaleElementReferenceException;
import org.openqa.selenium.TimeoutException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.interactions.Action;
import org.openqa.selenium.interactions.Actions;
import org.openqa.selenium.interactions.MoveTargetOutOfBoundsException;
import org.openqa.selenium.support.events.EventFiringWebDriver;
import org.openqa.selenium.support.ui.ExpectedCondition;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.WebDriverWait;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebBrowser
extends EventFiringWebDriver {
    protected static final Logger LOG = LoggerFactory.getLogger(WebBrowser.class);
    protected TasProperties properties;
    String mainWindow;

    public WebBrowser(WebDriver driver, TasProperties properties) {
        super(driver);
        this.properties = properties;
        LOG.info("Initialising driver '{}'", (Object)driver.toString());
    }

    public WebBrowser authenticatedSession(HttpState httpState) {
        if (httpState == null) {
            throw new RuntimeException("Failed to login");
        }
        this.navigate().to(this.properties.getShareUrl());
        this.manage().addCookie(new Cookie(httpState.getCookies()[0].getName(), httpState.getCookies()[0].getValue()));
        this.navigate().refresh();
        return this;
    }

    public void cleanUpAuthenticatedSession() {
        this.manage().deleteAllCookies();
    }

    public void mouseOver(WebElement element) {
        try {
            Parameter.checkIsMandotary("WebElement", element);
            new Actions((WebDriver)this).moveToElement(element).perform();
        }
        catch (MoveTargetOutOfBoundsException ex) {
            this.executeScript("arguments[0].scrollIntoView(true);", new Object[]{element});
            new Actions((WebDriver)this).moveToElement(element).perform();
        }
    }

    public void mouseOver(WebElement element, int xOffset, int yOffset) {
        Parameter.checkIsMandotary("WebElement", element);
        new Actions((WebDriver)this).moveToElement(element, xOffset, yOffset).perform();
    }

    public void mouseOverViaJavascript(WebElement webElement) {
        String javaScript = "var event = document.createEvent('MouseEvents');event.initMouseEvent(\"mouseover\",true, false, window, 0, 0, 0, 0, 0, false, false, false, false, 0, null);arguments[0].dispatchEvent(event);";
        this.executeScript(javaScript, new Object[]{webElement});
    }

    public void refresh() {
        this.navigate().refresh();
    }

    public void waitUntilElementHasAttribute(WebElement element, String attribute, String value) {
        Parameter.checkIsMandotary("Element", element);
        WebDriverWait wait = new WebDriverWait((WebDriver)this, this.properties.getExplicitWait());
        wait.until((Function)ExpectedConditions.attributeContains((WebElement)element, (String)attribute, (String)value));
    }

    public void waitUntilElementHasAttribute(By locator, String attribute, String value) {
        Parameter.checkIsMandotary("Element", locator);
        WebDriverWait wait = new WebDriverWait((WebDriver)this, this.properties.getExplicitWait());
        wait.until((Function)ExpectedConditions.attributeContains((By)locator, (String)attribute, (String)value));
    }

    public WebElement waitUntilElementVisible(By locator) {
        return this.waitUntilElementVisible(locator, this.properties.getExplicitWait());
    }

    public WebElement waitUntilElementVisible(By locator, long timeOutInSeconds) {
        Parameter.checkIsMandotary("Locator", locator);
        WebDriverWait wait = new WebDriverWait((WebDriver)this, timeOutInSeconds);
        return (WebElement)wait.until((Function)ExpectedConditions.visibilityOfElementLocated((By)locator));
    }

    public WebElement waitUntilElementIsPresent(By locator, long timeOutInSeconds) {
        Parameter.checkIsMandotary("Locator", locator);
        WebDriverWait wait = new WebDriverWait((WebDriver)this, timeOutInSeconds);
        return (WebElement)wait.until((Function)ExpectedConditions.presenceOfElementLocated((By)locator));
    }

    public WebElement waitUntilElementIsPresent(By locator) {
        return this.waitUntilElementIsPresent(locator, this.properties.getExplicitWait());
    }

    public WebElement waitUntilChildElementIsPresent(By parentLocator, By childLocator, long timeOutInSeconds) {
        Parameter.checkIsMandotary("Parent locator", parentLocator);
        Parameter.checkIsMandotary("Child locator", childLocator);
        WebDriverWait wait = new WebDriverWait((WebDriver)this, timeOutInSeconds);
        return (WebElement)wait.until((Function)ExpectedConditions.presenceOfNestedElementLocatedBy((By)parentLocator, (By)childLocator));
    }

    public WebElement waitUntilChildElementIsPresent(By parentLocator, By childLocator) {
        Parameter.checkIsMandotary("Parent locator", parentLocator);
        Parameter.checkIsMandotary("Child locator", childLocator);
        WebDriverWait wait = new WebDriverWait((WebDriver)this, this.properties.getExplicitWait());
        return (WebElement)wait.until((Function)ExpectedConditions.presenceOfNestedElementLocatedBy((By)parentLocator, (By)childLocator));
    }

    public WebElement waitUntilChildElementIsPresent(WebElement parentLocator, By childLocator, long timeOutInSeconds) {
        Parameter.checkIsMandotary("Parent locator", parentLocator);
        Parameter.checkIsMandotary("Child locator", childLocator);
        WebDriverWait wait = new WebDriverWait((WebDriver)this, timeOutInSeconds);
        return (WebElement)wait.until((Function)ExpectedConditions.presenceOfNestedElementLocatedBy((WebElement)parentLocator, (By)childLocator));
    }

    public WebElement waitUntilChildElementIsPresent(WebElement parentLocator, By childLocator) {
        Parameter.checkIsMandotary("Parent locator", parentLocator);
        Parameter.checkIsMandotary("Child locator", childLocator);
        WebDriverWait wait = new WebDriverWait((WebDriver)this, this.properties.getExplicitWait());
        return (WebElement)wait.until((Function)ExpectedConditions.presenceOfNestedElementLocatedBy((WebElement)parentLocator, (By)childLocator));
    }

    public WebElement waitUntilElementVisible(WebElement element) {
        return this.waitUntilElementVisible(element, this.properties.getExplicitWait());
    }

    public WebElement waitUntilElementVisible(WebElement element, long timeOutInSeconds) {
        Parameter.checkIsMandotary("Element", element);
        WebDriverWait wait = new WebDriverWait((WebDriver)this, timeOutInSeconds);
        return (WebElement)wait.until((Function)ExpectedConditions.visibilityOf((WebElement)element));
    }

    public List<WebElement> waitUntilElementsVisible(By locator) {
        Parameter.checkIsMandotary("Locator", locator);
        WebDriverWait wait = new WebDriverWait((WebDriver)this, this.properties.getExplicitWait());
        return (List)wait.until((Function)ExpectedConditions.visibilityOfAllElementsLocatedBy((By)locator));
    }

    public List<WebElement> waitUntilElementsVisible(List<WebElement> elements) {
        WebDriverWait wait = new WebDriverWait((WebDriver)this, this.properties.getExplicitWait());
        return (List)wait.until((Function)ExpectedConditions.visibilityOfAllElements(elements));
    }

    public void waitUntilElementIsDisplayedWithRetry(By locator) {
        this.waitUntilElementIsDisplayedWithRetry(locator, 0);
    }

    public void waitUntilElementIsDisplayedWithRetry(By locator, int secondsToWait) {
        this.waitUntilElementIsDisplayedWithRetry(locator, secondsToWait, 3);
    }

    public void waitUntilElementIsDisplayedWithRetry(By locator, int secondsToWait, int retryTimes) {
        Parameter.checkIsMandotary("Locator", locator);
        for (int counter = 1; counter <= retryTimes && !this.isElementDisplayed(locator); ++counter) {
            LOG.info(String.format("Wait for element %s seconds after refresh: %s", secondsToWait, counter));
            this.refresh();
            this.waitInSeconds(secondsToWait);
        }
    }

    public WebElement waitWithRetryAndReturnWebElement(By locator, int secondsToWait, int retryTimes) {
        this.waitUntilElementIsDisplayedWithRetry(locator, secondsToWait, retryTimes);
        return this.findElement(locator);
    }

    public void waitUntilElementIsDisplayedWithRetry(WebElement webElement, int secondsToWait) {
        Parameter.checkIsMandotary("WebElement", webElement);
        int retryRefreshCount = 3;
        for (int counter = 1; counter <= retryRefreshCount && !this.isElementDisplayed(webElement); ++counter) {
            LOG.info(String.format("Wait for element %s seconds after refresh: %s", secondsToWait, counter));
            this.refresh();
            this.waitInSeconds(secondsToWait);
        }
    }

    public void waitUntilElementDisappearsWithRetry(By locator, int secondsToWait) {
        Parameter.checkIsMandotary("Locator", locator);
        int retryRefreshCount = 3;
        for (int counter = 1; counter <= retryRefreshCount && this.isElementDisplayed(locator); ++counter) {
            LOG.info(String.format("Wait for element %s seconds after refresh: %s", secondsToWait, counter));
            this.refresh();
            this.waitInSeconds(secondsToWait);
        }
    }

    public void waitUntilWebElementIsDisplayedWithRetry(WebElement webElement) {
        this.waitUntilWebElementIsDisplayedWithRetry(webElement, 0);
    }

    public void waitUntilWebElementIsDisplayedWithRetry(WebElement webElement, int secondsToWait) {
        Parameter.checkIsMandotary("WebElement", webElement);
        int retryRefreshCount = 3;
        for (int counter = 1; counter <= retryRefreshCount && !this.isElementDisplayed(webElement); ++counter) {
            LOG.info(String.format("Wait for web element %s seconds after refresh: %s", secondsToWait, counter));
            this.refresh();
            this.waitInSeconds(secondsToWait);
        }
    }

    public WebElement waitUntilElementClickable(WebElement element) {
        WebDriverWait wait = new WebDriverWait((WebDriver)this, this.properties.getExplicitWait());
        return (WebElement)wait.until((Function)ExpectedConditions.elementToBeClickable((WebElement)element));
    }

    public WebElement waitUntilElementClickable(By locator) {
        WebDriverWait wait = new WebDriverWait((WebDriver)this, this.properties.getExplicitWait());
        return (WebElement)wait.until((Function)ExpectedConditions.elementToBeClickable((By)locator));
    }

    public WebElement waitUntilElementClickable(By locator, long timeOutInSeconds) {
        Parameter.checkIsMandotary("Locator", locator);
        WebDriverWait wait = new WebDriverWait((WebDriver)this, timeOutInSeconds);
        return (WebElement)wait.until((Function)ExpectedConditions.elementToBeClickable((By)locator));
    }

    public WebElement waitUntilElementClickable(WebElement element, long timeOutInSeconds) {
        Parameter.checkIsMandotary("Element", element);
        WebDriverWait wait = new WebDriverWait((WebDriver)this, timeOutInSeconds);
        return (WebElement)wait.until((Function)ExpectedConditions.elementToBeClickable((WebElement)element));
    }

    public void waitUntilElementContainsText(WebElement element, String text) {
        Parameter.checkIsMandotary("Element", element);
        WebDriverWait wait = new WebDriverWait((WebDriver)this, this.properties.getExplicitWait());
        wait.until((Function)ExpectedConditions.textToBePresentInElement((WebElement)element, (String)text));
    }

    public void waitUntilElementContainsText(By locator, String text) {
        Parameter.checkIsMandotary("Locator", locator);
        WebDriverWait wait = new WebDriverWait((WebDriver)this, this.properties.getExplicitWait());
        wait.until((Function)ExpectedConditions.textToBePresentInElementLocated((By)locator, (String)text));
    }

    public void waitUrlContains(String URLfraction, long timeOutInSeconds) {
        Parameter.checkIsMandotary("Element", URLfraction);
        WebDriverWait wait = new WebDriverWait((WebDriver)this, timeOutInSeconds);
        wait.until((Function)ExpectedConditions.urlContains((String)URLfraction));
    }

    public void waitUntilElementDeletedFromDom(By locator) {
        this.waitUntilElementDeletedFromDom(locator, this.properties.getExplicitWait());
    }

    public void waitUntilElementDeletedFromDom(By locator, long timeOutInSeconds) {
        Parameter.checkIsMandotary("Locator", locator);
        WebDriverWait wait = new WebDriverWait((WebDriver)this, timeOutInSeconds);
        try {
            wait.until((Function)ExpectedConditions.stalenessOf((WebElement)this.findElement(locator)));
        }
        catch (NoSuchElementException noSuchElementException) {
            // empty catch block
        }
    }

    public void waitUntilElementDisappears(By locator) {
        this.waitUntilElementDisappears(locator, this.properties.getExplicitWait());
    }

    public void waitUntilElementDisappears(By locator, long timeOutInSeconds) {
        Parameter.checkIsMandotary("Locator", locator);
        WebDriverWait wait = new WebDriverWait((WebDriver)this, timeOutInSeconds);
        wait.until((Function)ExpectedConditions.invisibilityOfElementLocated((By)locator));
    }

    public void waitUntilElementDisappears(WebElement locator, long timeOutInSeconds) {
        Parameter.checkIsMandotary("Locator", locator);
        WebDriverWait wait = new WebDriverWait((WebDriver)this, timeOutInSeconds);
        wait.until((Function)ExpectedConditions.invisibilityOf((WebElement)locator));
    }

    public void waitUntilElementDisappears(WebElement locator) {
        this.waitUntilElementDisappears(locator, this.properties.getExplicitWait());
    }

    public boolean isElementDisplayed(By locator) {
        Parameter.checkIsMandotary("Locator", locator);
        try {
            return this.findElement(locator).isDisplayed();
        }
        catch (NoSuchElementException noSuchElementException) {
        }
        catch (TimeoutException timeoutException) {
        }
        catch (StaleElementReferenceException staleElementReferenceException) {
            // empty catch block
        }
        return false;
    }

    public boolean isElementDisplayed(WebElement element) {
        try {
            Parameter.checkIsMandotary("WebElement", element);
            return element.isDisplayed();
        }
        catch (NoSuchElementException noSuchElementException) {
        }
        catch (TimeoutException timeoutException) {
        }
        catch (StaleElementReferenceException staleElementReferenceException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return false;
    }

    public boolean isElementDisplayed(WebElement element, By locator) {
        try {
            Parameter.checkIsMandotary("WebElement", element);
            return element.findElement(locator).isDisplayed();
        }
        catch (NoSuchElementException noSuchElementException) {
        }
        catch (TimeoutException timeoutException) {
        }
        catch (StaleElementReferenceException staleElementReferenceException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return false;
    }

    public String getPreviousUrl() {
        String url = (String)this.executeScript("return document.referrer;", new Object[0]);
        if (url == null || url.isEmpty()) {
            throw new UnsupportedOperationException("There is no previous url value");
        }
        return url;
    }

    public void switchToFrame(String frameId) {
        Parameter.checkIsMandotary("FrameId", frameId);
        this.switchTo().frame(frameId);
    }

    public void switchToDefaultContent() {
        this.switchTo().defaultContent();
    }

    public void switchWindow() {
        this.mainWindow = this.getWindowHandle();
        Set windows = this.getWindowHandles();
        windows.remove(this.mainWindow);
        this.switchToWindow((String)windows.iterator().next());
    }

    public void switchWindow(int windowIndex) {
        this.mainWindow = this.getWindowHandle();
        Set windows = this.getWindowHandles();
        int windowsNumber = windows.size();
        int retryRefreshCount = 5;
        for (int counter = 1; counter <= retryRefreshCount; ++counter) {
            if (windowsNumber == windowIndex + 1) {
                windows.remove(this.mainWindow);
                this.switchToWindow((String)windows.iterator().next());
                break;
            }
            LOG.info("Wait for window: " + counter);
            this.waitInSeconds(2);
            windowsNumber = this.getWindowHandles().size();
        }
    }

    public void switchWindow(String winHandler) {
        this.mainWindow = this.getWindowHandle();
        for (String winHandle : this.getWindowHandles()) {
            this.switchTo().window(winHandle);
            if (this.getCurrentUrl().contains(winHandler)) break;
            this.switchTo().window(this.mainWindow);
        }
    }

    public void closeWindowAndSwitchBack() {
        this.close();
        this.switchToWindow(this.mainWindow);
    }

    public void closeWindowAndSwitchBackParametrized(String windowToSwitchTo, String windowToClose) {
        String currentWindow = this.getWindowHandle();
        if (currentWindow.equals(windowToClose)) {
            this.close();
            this.switchToWindow(windowToSwitchTo);
        } else {
            LOG.info("You are not on the expected page, you are on: " + this.getCurrentUrl());
        }
    }

    public void closeWindowAcceptingModalDialog() {
        this.close();
        Alert alert = this.switchTo().alert();
        String alertText = alert.getText().trim();
        LOG.info("Alert data: " + alertText);
        alert.accept();
        this.switchToWindow(this.mainWindow);
    }

    public void switchToWindow(String windowHandle) {
        Parameter.checkIsMandotary("windowHandle", windowHandle);
        this.switchTo().window(windowHandle);
    }

    public Cookie getCookie(String name) {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("Cookie identifier is required.");
        }
        Set cookies = this.manage().getCookies();
        if (cookies != null) {
            for (Cookie cookie : cookies) {
                if (!name.equalsIgnoreCase(cookie.getName())) continue;
                return cookie;
            }
        }
        return null;
    }

    public void deleteCookies() {
        this.manage().deleteAllCookies();
    }

    public void deleteCookie(Cookie cookie) {
        Parameter.checkIsMandotary("Cookie", cookie);
        this.manage().deleteCookie(cookie);
    }

    public void maximize() {
        this.manage().window().maximize();
    }

    public void dragAndDrop(WebElement source, WebElement target) {
        Parameter.checkIsMandotary("source element", source);
        Parameter.checkIsMandotary("target element", target);
        Actions builder = new Actions((WebDriver)this);
        builder.dragAndDrop(source, target).perform();
    }

    public void dragAndDrop(WebElement source, int x, int y) {
        Parameter.checkIsMandotary("source element", source);
        Actions builder = new Actions((WebDriver)this);
        Action dragAndDrop = builder.dragAndDropBy(source, x, y).build();
        dragAndDrop.perform();
    }

    public void doubleClickOnElement(WebElement element) {
        Parameter.checkIsMandotary("doubleclick element", element);
        Actions builder = new Actions((WebDriver)this);
        Action doubleClick = builder.doubleClick(element).build();
        doubleClick.perform();
    }

    public void rightClickOnElement(WebElement element) {
        Parameter.checkIsMandotary("right element", element);
        Actions builder = new Actions((WebDriver)this);
        Action rightClick = builder.contextClick(element).build();
        rightClick.perform();
    }

    public WebElement findFirstDisplayedElement(By locator) {
        List<WebElement> elementList = this.findDisplayedElementsFromLocator(locator);
        if (elementList.size() != 0) {
            return elementList.get(0);
        }
        return null;
    }

    public WebElement findFirstElementWithValue(By locator, String value) {
        List<WebElement> elementList = this.waitUntilElementsVisible(locator);
        for (WebElement element : elementList) {
            if (!element.getText().contains(value)) continue;
            return element;
        }
        return null;
    }

    public WebElement findFirstElementWithValue(List<WebElement> list, String value) {
        for (WebElement element : list) {
            if (!element.getText().contains(value)) continue;
            return element;
        }
        return null;
    }

    public WebElement findFirstElementWithExactValue(List<WebElement> list, String value) {
        for (WebElement element : list) {
            if (!element.getText().equals(value)) continue;
            return element;
        }
        return null;
    }

    public List<WebElement> findDisplayedElementsFromLocator(By selector) {
        Parameter.checkIsMandotary("Locator", selector);
        List elementList = this.findElements(selector);
        ArrayList<WebElement> displayedElementList = new ArrayList<WebElement>();
        for (WebElement elementSelected : elementList) {
            if (!elementSelected.isDisplayed()) continue;
            displayedElementList.add(elementSelected);
        }
        return displayedElementList;
    }

    public void selectOptionFromFilterOptionsList(String option, List<WebElement> filterOptionsList) {
        Parameter.checkIsMandotary("Filter options", filterOptionsList);
        for (WebElement webElement : filterOptionsList) {
            if (!webElement.getText().contains(option)) continue;
            webElement.click();
            break;
        }
    }

    public boolean isOptionSelectedForFilter(String option, WebElement filterElement) {
        try {
            String actualOption = filterElement.getText();
            actualOption = actualOption.substring(0, actualOption.length() - 2);
            return actualOption.equals(option);
        }
        catch (TimeoutException te) {
            throw new PageOperationException("Unable to retrieve the '" + String.valueOf(filterElement) + "' button", te);
        }
    }

    public void scrollToElement(WebElement element) {
        this.executeJavaScript(String.format("window.scrollTo(0, '%s')", element.getLocation().getY()));
    }

    public void scrollIntoView(WebElement element) {
        this.executeJavaScript("arguments[0].scrollIntoView(true);", element);
    }

    public void waitInSeconds(int seconds) {
        long time1;
        long time0 = System.currentTimeMillis();
        while ((time1 = System.currentTimeMillis()) - time0 < (long)(seconds * 1000)) {
        }
    }

    public void executeJavaScript(String command) {
        if (this instanceof JavascriptExecutor) {
            this.executeScript(command, new Object[0]);
        }
    }

    public void executeJavaScript(String command, WebElement element) {
        if (this instanceof JavascriptExecutor) {
            this.executeScript(command, new Object[]{element});
        }
    }

    public void clickJS(WebElement elementToClick) {
        this.executeJavaScript("arguments[0].click();", elementToClick);
    }

    public boolean isAlertPresent() {
        try {
            this.switchTo().alert();
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void handleModalDialogAcceptingAlert() {
        if (this.isAlertPresent()) {
            Alert alert = this.switchTo().alert();
            String alertText = alert.getText().trim();
            LOG.info("Alert data: " + alertText);
            alert.accept();
        }
    }

    public void handleModalDialogDismissingAlert() {
        if (this.isAlertPresent()) {
            Alert alert = this.switchTo().alert();
            String alertText = alert.getText().trim();
            LOG.info("Alert data: " + alertText);
            alert.dismiss();
        }
    }

    public void focusOnWebElement(WebElement webElement) {
        webElement.sendKeys(new CharSequence[]{Keys.TAB});
    }

    public void waitUntilElementIsVisibleWithRetry(By locator, int retryCount) {
        Parameter.checkIsMandotary("Locator", locator);
        for (int counter = 0; !this.isElementDisplayed(locator) && counter <= retryCount; ++counter) {
            this.waitInSeconds(2);
        }
    }

    public void waitUntilElementDoesNotContainText(WebElement element, String text) {
        Parameter.checkIsMandotary("Element", element);
        WebDriverWait wait = new WebDriverWait((WebDriver)this, this.properties.getExplicitWait());
        wait.until((Function)ExpectedConditions.not((ExpectedCondition)ExpectedConditions.textToBePresentInElement((WebElement)element, (String)text)));
    }

    public List<String> getTextFromLocatorList(By elementsList) {
        List<WebElement> elements = this.waitUntilElementsVisible(elementsList);
        return elements.stream().map(WebElement::getText).collect(Collectors.toList());
    }

    public List<String> getTextFromElementList(List<WebElement> elementsList) {
        return elementsList.stream().map(WebElement::getText).collect(Collectors.toList());
    }
}

