/*
 * Decompiled with CFR 0.152.
 */
package org.gytheio.content.transform.ffmpeg;

import java.io.File;
import java.io.FilenameFilter;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.gytheio.content.ContentReference;
import org.gytheio.content.mediatype.FileMediaType;
import org.gytheio.content.transform.AbstractFileContentTransformerWorker;
import org.gytheio.content.transform.AbstractRuntimeExecContentTransformerWorker;
import org.gytheio.content.transform.ContentTransformerWorkerProgressReporter;
import org.gytheio.content.transform.ffmpeg.FfmpegInputStreamReaderThreadFactory;
import org.gytheio.content.transform.options.AudioTransformationOptions;
import org.gytheio.content.transform.options.ImageResizeOptions;
import org.gytheio.content.transform.options.ImageTransformationOptions;
import org.gytheio.content.transform.options.TemporalSourceOptions;
import org.gytheio.content.transform.options.TransformationOptions;
import org.gytheio.content.transform.options.VideoTransformationOptions;
import org.gytheio.error.GytheioRuntimeException;
import org.gytheio.util.exec.RuntimeExec;

public class FfmpegContentTransformerWorker
extends AbstractRuntimeExecContentTransformerWorker {
    private static final Log logger = LogFactory.getLog(FfmpegContentTransformerWorker.class);
    protected static final String CMD_OPT_ASSIGNMENT = " ";
    protected static final String CMD_OPT_PARAM_ASSIGNMENT = "=";
    protected static final String CMD_OPT_DELIMITER = " ";
    protected static final String CMD_OPT_NUM_VIDEO_FRAMES = "-vframes";
    protected static final String CMD_OPT_DISABLE_AUDIO = "-an";
    protected static final String CMD_OPT_DISABLE_VIDEO = "-vn";
    protected static final String CMD_OPT_DISABLE_SUBTITLES = "-sn";
    protected static final String CMD_OPT_VIDEO_CODEC_v0 = "-vcodec";
    protected static final String CMD_OPT_VIDEO_CODEC_v1 = "-c:v";
    protected static final String CMD_OPT_VIDEO_BITRATE_v0 = "-vb";
    protected static final String CMD_OPT_VIDEO_BITRATE_v1 = "-b:v";
    protected static final String CMD_OPT_VIDEO_PRESET = "-vpre";
    protected static final String CMD_OPT_AUDIO_CODEC_v0 = "-acodec";
    protected static final String CMD_OPT_AUDIO_CODEC_v1 = "-c:a";
    protected static final String CMD_OPT_AUDIO_BITRATE_v0 = "-ab";
    protected static final String CMD_OPT_AUDIO_BITRATE_v1 = "-b:a";
    protected static final String CMD_OPT_AUDIO_SAMPLING_RATE = "-ar";
    protected static final String CMD_OPT_AUDIO_CHANNELS = "-ac";
    protected static final String CMD_OPT_FORMAT = "-f";
    protected static final String CMD_OPT_DURATION = "-t";
    protected static final String CMD_OPT_OFFSET = "-ss";
    protected static final String CMD_OPT_SIZE = "-s";
    protected static final String CMD_OPT_SCALE = "-vf scale";
    protected static final String CMD_OPT_FRAME_RATE = "-r";
    protected static final String CMD_OPT_FRAME_RATE_FILTER = "-vf fps=fps";
    protected static final String CMD_OPT_MOV_FLAGS = "-movflags";
    protected static final String CMD_OPT_MOV_FLAGS_FASTSTART = "+faststart";
    protected static final String CMD_OPT_ENABLE_EXPERIMENTAL = "-strict experimental";
    protected static final String CMD_OPT_PAIR_1_FRAME = "-vframes 1";
    protected static final String CMD_OPT_MULTI_TARGET_INDEX_FORMATTER = "%03d";
    protected static final String CMD_OPT_MULTI_TARGET_INDEX_REGEX = "\\\\d{3}";
    protected static final String DEFAULT_VIDEO_PRESET = "libx264-default";
    protected static final String DEFAULT_VIDEO_PRESET_PREFIX = "";
    protected static final String DEFAULT_VIDEO_PRESET_SUFFIX = ".ffpreset";
    public static final String VAR_SOURCE_OPTIONS = "sourceOptions";
    public static final String VAR_TARGET_OPTIONS = "targetOptions";
    public static final String VAR_OFFSET = "offset";
    public static final String VAR_DURATION = "duration";
    protected static final String DEFAULT_OFFSET = "00:00:00";
    private String ffmpegExe = "ffmpeg";
    private String ffmpegPresetsDir;
    private String versionFullDetailsString;

    protected void initializeExecuter() {
        if (this.executer == null) {
            if (System.getProperty("ffmpeg.exe") != null) {
                this.ffmpegExe = System.getProperty("ffmpeg.exe");
            }
            if (System.getProperty("ffmpeg.presets.dir") != null) {
                this.ffmpegPresetsDir = System.getProperty("ffmpeg.presets.dir");
            }
            this.executer = new RuntimeExec();
            HashMap<String, String[]> commandsAndArguments = new HashMap<String, String[]>();
            commandsAndArguments.put(".*", new String[]{this.ffmpegExe, "-y", "SPLIT:${sourceOptions}", "-i", "${source}", "SPLIT:${targetOptions}", "${target}"});
            this.executer.setCommandsAndArguments(commandsAndArguments);
        }
    }

    protected void initializeVersionDetailsExecuter() {
        if (this.versionDetailsExecuter == null) {
            this.versionDetailsExecuter = new RuntimeExec();
            HashMap<String, String[]> checkCommandsAndArguments = new HashMap<String, String[]>();
            checkCommandsAndArguments.put(".*", new String[]{this.ffmpegExe, "-version"});
            this.versionDetailsExecuter.setCommandsAndArguments(checkCommandsAndArguments);
        }
    }

    protected void initializeFileDetailsExecuter() {
        if (this.fileDetailsExecuter == null) {
            this.fileDetailsExecuter = new RuntimeExec();
            HashMap<String, String[]> commandsAndArguments = new HashMap<String, String[]>();
            commandsAndArguments.put(".*", new String[]{this.ffmpegExe, "-i", "${source}"});
            this.fileDetailsExecuter.setCommandsAndArguments(commandsAndArguments);
        }
    }

    protected void initializationTest() {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("FFmpeg version " + this.getFfmpegVersionNumber() + " initialization test..."));
        }
        if (this.getFfmpegVersionNumber() == null || "null".equals(this.getFfmpegVersionNumber())) {
            throw new GytheioRuntimeException("Could not determine version of FFmpeg");
        }
        try {
            this.initializationTest("org/gytheio/content/transform/ffmpeg/test.mp4", FileMediaType.VIDEO_AVI.getMediaType(), (TransformationOptions)new VideoTransformationOptions());
        }
        catch (Exception e) {
            throw new GytheioRuntimeException("Could not initialize worker: " + e.getMessage(), (Throwable)e);
        }
    }

    protected String getVersionDetailOutput(String[] arguments) {
        String[] command;
        String ffmpegVersionExe = this.ffmpegExe;
        RuntimeExec additionalDetailsExecuter = new RuntimeExec();
        if (this.versionDetailsExecuter != null && (command = this.versionDetailsExecuter.getCommand()) != null && command.length > 0) {
            ffmpegVersionExe = command[0];
        }
        HashMap<String, String[]> checkCommandsAndArguments = new HashMap<String, String[]>();
        checkCommandsAndArguments.put(".*", (String[])ArrayUtils.addAll((Object[])new String[]{ffmpegVersionExe}, (Object[])arguments));
        additionalDetailsExecuter.setCommandsAndArguments(checkCommandsAndArguments);
        String output = null;
        try {
            RuntimeExec.ExecutionResult result = additionalDetailsExecuter.execute();
            String out = result.getStdOut().trim();
            output = !out.equals(DEFAULT_VIDEO_PRESET_PREFIX) ? out : result.getStdErr().trim();
        }
        catch (Throwable e) {
            logger.info((Object)(((Object)((Object)this)).getClass().getSimpleName() + " could not get additional details: " + (e.getMessage() != null ? e.getMessage() : DEFAULT_VIDEO_PRESET_PREFIX)));
        }
        return output;
    }

    protected void initializeVersionDetailsString() {
        String formats;
        super.initializeVersionDetailsString();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("StdOut versionDetailsString=" + this.versionDetailsString));
        }
        if (this.versionDetailsString == null) {
            RuntimeExec.ExecutionResult result = this.versionDetailsExecuter.execute();
            this.versionDetailsString = result.getStdErr().trim();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("StdErr versionDetailsString=" + this.versionDetailsString));
            }
        }
        this.versionFullDetailsString = this.versionDetailsString + DEFAULT_VIDEO_PRESET_PREFIX;
        String fullHelp = this.getVersionDetailOutput(new String[]{"-h", "full"});
        if (fullHelp != null) {
            this.versionFullDetailsString = this.versionFullDetailsString + "\n\n" + fullHelp;
        }
        if ((formats = this.getVersionDetailOutput(new String[]{"-formats"})) != null) {
            this.versionFullDetailsString = this.versionFullDetailsString + "\n\n" + formats;
        }
        this.reinitializeVersionString();
    }

    protected void reinitializeVersionString() {
        if (this.getProperties() == null) {
            this.versionString = ((Object)((Object)this)).getClass().getSimpleName();
        } else {
            String nameFormat = this.getProperties().getProperty("name");
            String name = MessageFormat.format(nameFormat, this.getFfmpegVersionNumber());
            this.versionString = name + " " + this.getProperties().getProperty("version");
        }
    }

    public static boolean isSupportedSource(String mediaType) {
        return mediaType.startsWith("video/") && !mediaType.equals("video/x-rad-screenplay") && !mediaType.equals("video/x-sgi-movie") && !mediaType.equals("video/mpeg2") || mediaType.startsWith("audio/") && !mediaType.equals("audio/vnd.adobe.soundbooth") || mediaType.equals("application/mxf");
    }

    public static boolean isSupportedTarget(String mimetype) {
        return mimetype.startsWith("video/") && !mimetype.equals("video/x-rad-screenplay") && !mimetype.equals("video/x-sgi-movie") && !mimetype.equals("video/mpeg2") || mimetype.startsWith("image/") && !mimetype.equals(FileMediaType.IMAGE_SVG.getMediaType()) && !mimetype.equals(FileMediaType.APPLICATION_PHOTOSHOP.getMediaType()) && !mimetype.equals(FileMediaType.IMG_DWG.getMediaType()) && !mimetype.equals("image/vnd.adobe.premiere") && !mimetype.equals("image/x-portable-anymap") && !mimetype.equals("image/x-xpixmap") && !mimetype.equals("image/x-dwt") && !mimetype.equals("image/cgm") && !mimetype.equals("image/ief") || mimetype.startsWith("audio/") && !mimetype.equals("audio/vnd.adobe.soundbooth");
    }

    public boolean isTransformable(List<String> sourceMediaTypes, String targetMediaType, TransformationOptions options) {
        if (!this.isAvailable()) {
            return false;
        }
        if (sourceMediaTypes.size() > 1) {
            return false;
        }
        String sourceMediaType = sourceMediaTypes.get(0);
        if (logger.isTraceEnabled() && options != null) {
            logger.trace((Object)("checking support of sourceMediaType=" + sourceMediaType + " " + "targetMediaType=" + targetMediaType + " " + options.getClass().getCanonicalName() + CMD_OPT_PARAM_ASSIGNMENT + options.toString()));
        }
        if (sourceMediaType.startsWith("audio/") && targetMediaType.startsWith("image/")) {
            return false;
        }
        return FfmpegContentTransformerWorker.isSupportedSource(sourceMediaType) && FfmpegContentTransformerWorker.isSupportedTarget(targetMediaType);
    }

    protected List<File> transformInternal(List<AbstractFileContentTransformerWorker.FileContentReferencePair> sourcePairs, List<AbstractFileContentTransformerWorker.FileContentReferencePair> targetPairs, TransformationOptions options, ContentTransformerWorkerProgressReporter progressReporter) throws Exception {
        String targetMimetype;
        if (sourcePairs.size() > 1 || targetPairs.size() > 1) {
            throw new IllegalArgumentException("Only single source and target transformations are currently supported");
        }
        AbstractFileContentTransformerWorker.FileContentReferencePair sourcePair = sourcePairs.iterator().next();
        AbstractFileContentTransformerWorker.FileContentReferencePair targetPair = targetPairs.iterator().next();
        File sourceFile = sourcePair.getFile();
        File targetFile = targetPair.getFile();
        String sourceMimetype = sourcePair.getContentReference().getMediaType();
        boolean isStoryboardThumbnailRequest = this.isStoryboardThumbnailRequest(sourceMimetype, targetMimetype = targetPair.getContentReference().getMediaType(), options);
        if (isStoryboardThumbnailRequest) {
            this.targetContentReferenceHandler.delete(targetPair.getContentReference());
            ContentReference multiTargetContentReference = this.createMultiTargetContentReference(targetMimetype);
            List multiTargetPairs = this.getTargetPairs(Arrays.asList(multiTargetContentReference));
            AbstractFileContentTransformerWorker.FileContentReferencePair multiTargetPair = (AbstractFileContentTransformerWorker.FileContentReferencePair)multiTargetPairs.iterator().next();
            targetFile = multiTargetPair.getFile();
        }
        this.singleTransformInternal(sourceFile, sourceMimetype, targetFile, targetMimetype, options, progressReporter);
        if (isStoryboardThumbnailRequest) {
            File targetParent = targetFile.getParentFile();
            final String multiTargetFilenameMatch = targetFile.getName().replaceFirst(CMD_OPT_MULTI_TARGET_INDEX_FORMATTER, CMD_OPT_MULTI_TARGET_INDEX_REGEX);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Looking for filenames matching " + multiTargetFilenameMatch + " in " + targetParent.getAbsolutePath()));
            }
            File[] multiTargetFiles = targetParent.listFiles(new FilenameFilter(){

                @Override
                public boolean accept(File dir, String filename) {
                    return filename.matches(multiTargetFilenameMatch);
                }
            });
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Found " + multiTargetFiles.length + " files"));
            }
            return Arrays.asList(multiTargetFiles);
        }
        return Arrays.asList(targetFile);
    }

    protected void singleTransformInternal(File sourceFile, String sourceMimetype, File targetFile, String targetMimetype, TransformationOptions options, ContentTransformerWorkerProgressReporter progressReporter) throws Exception {
        RuntimeExec.ExecutionResult result;
        HashMap<String, String> properties = new HashMap<String, String>(5);
        String sourceCommandOptions = this.getSourceCommandOptions(sourceFile, targetFile, sourceMimetype, targetMimetype, options);
        String targetCommandOptions = this.getTargetCommandOptions(sourceFile, targetFile, sourceMimetype, targetMimetype, options);
        properties.put(VAR_SOURCE_OPTIONS, sourceCommandOptions.trim());
        properties.put("source", sourceFile.getAbsolutePath());
        properties.put(VAR_TARGET_OPTIONS, targetCommandOptions.trim());
        properties.put("target", targetFile.getAbsolutePath());
        long timeoutMs = options.getTimeoutMs();
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Executing with timeoutMs=" + timeoutMs + ", properties=" + ((Object)properties).toString()));
        }
        if ((result = this.executer.execute(properties, null, (RuntimeExec.InputStreamReaderThreadFactory)new FfmpegInputStreamReaderThreadFactory(progressReporter, this.isVersion1orGreater()), timeoutMs)).getExitValue() != 0 && result.getStdErr() != null && result.getStdErr().length() > 0) {
            throw new Exception("Failed to perform ffmpeg transformation: \n" + result.toString() + "\n\n-------- Full Error --------\n" + result.getStdErr() + "\n----------------------------\n");
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("ffmpeg executed successfully: \n" + result));
        }
    }

    protected String getSourceCommandOptions(File sourceFile, File targetFile, String sourceMimetype, String targetMimetype, TransformationOptions options) throws Exception {
        String commandOptions = DEFAULT_VIDEO_PRESET_PREFIX;
        String sourceTemporalOptions = this.getSourceTemporalCommandOptions(sourceMimetype, targetMimetype, options);
        if (sourceTemporalOptions != null && !sourceTemporalOptions.equals(DEFAULT_VIDEO_PRESET_PREFIX)) {
            commandOptions = commandOptions + " " + sourceTemporalOptions;
        }
        return commandOptions;
    }

    protected String getTargetCommandOptions(File sourceFile, File targetFile, String sourceMimetype, String targetMimetype, TransformationOptions options) throws Exception {
        String targetAudioOptions;
        String targetVideoOptions;
        String resizeOptions;
        String exclusionOptions;
        String formatOptions;
        String commandOptions = DEFAULT_VIDEO_PRESET_PREFIX;
        String targetTemporalOptions = this.getTargetTemporalCommandOptions(sourceMimetype, targetMimetype, options);
        if (targetTemporalOptions != null && !targetTemporalOptions.equals(DEFAULT_VIDEO_PRESET_PREFIX)) {
            commandOptions = commandOptions + " " + targetTemporalOptions;
        }
        if ((formatOptions = this.getFormatCommandOptions(sourceMimetype, targetMimetype)) != null && !formatOptions.equals(DEFAULT_VIDEO_PRESET_PREFIX)) {
            commandOptions = commandOptions + " " + formatOptions;
        }
        if ((exclusionOptions = this.getComponentExclusionCommandOptions(sourceMimetype, targetMimetype)) != null && !exclusionOptions.equals(DEFAULT_VIDEO_PRESET_PREFIX)) {
            commandOptions = commandOptions + " " + exclusionOptions;
        }
        if ((resizeOptions = this.getTargetResizeCommandOptions(options, sourceFile)) != null && !resizeOptions.equals(DEFAULT_VIDEO_PRESET_PREFIX)) {
            commandOptions = commandOptions + " " + resizeOptions;
        }
        if ((targetVideoOptions = this.getTargetVideoCommandOptions(sourceMimetype, targetMimetype, options)) != null && !targetVideoOptions.equals(DEFAULT_VIDEO_PRESET_PREFIX)) {
            commandOptions = commandOptions + " " + targetVideoOptions;
        }
        if ((targetAudioOptions = this.getTargetAudioCommandOptions(targetMimetype, options)) != null && !targetAudioOptions.equals(DEFAULT_VIDEO_PRESET_PREFIX)) {
            commandOptions = commandOptions + " " + targetAudioOptions;
        }
        return commandOptions;
    }

    protected String getFfmpegVersionNumber() {
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("getFfmpegVersionNumber versionDetailsString=" + this.versionDetailsString));
        }
        Pattern verisonNumPattern = Pattern.compile("(FFmpeg version |ffmpeg version )((\\w|\\.|\\-)+)(.*)");
        try {
            Matcher versionNumMatcher = verisonNumPattern.matcher(this.versionDetailsString);
            if (versionNumMatcher.find()) {
                return versionNumMatcher.group(2);
            }
        }
        catch (Throwable e) {
            logger.info((Object)("Could not determine version of FFmpeg: " + e.getMessage()));
        }
        return null;
    }

    protected boolean isFilterSupported() {
        String ffmpegVersionNumber = this.getFfmpegVersionNumber();
        if (ffmpegVersionNumber == null) {
            return false;
        }
        if (ffmpegVersionNumber.startsWith("N-")) {
            return true;
        }
        DefaultArtifactVersion thisVersion = new DefaultArtifactVersion(ffmpegVersionNumber);
        DefaultArtifactVersion filtersSupportedVersion = new DefaultArtifactVersion("0.7");
        return thisVersion.compareTo((ArtifactVersion)filtersSupportedVersion) >= 0;
    }

    public boolean isVersion1orGreater() {
        String ffmpegVersionNumber = this.getFfmpegVersionNumber();
        if (ffmpegVersionNumber == null) {
            return false;
        }
        if (ffmpegVersionNumber.startsWith("N-")) {
            return true;
        }
        DefaultArtifactVersion thisVersion = new DefaultArtifactVersion(ffmpegVersionNumber);
        DefaultArtifactVersion version1 = new DefaultArtifactVersion("1.0");
        return thisVersion.compareTo((ArtifactVersion)version1) >= 0;
    }

    protected String getResolution(String details) {
        String[] segments;
        if (details == null) {
            return null;
        }
        for (String segment : segments = details.split(", ")) {
            if (!segment.matches("[0-9]+x[0-9]+( \\[.*\\])?")) continue;
            if (segment.contains(" ")) {
                return segment.split(" ")[0];
            }
            return segment;
        }
        return null;
    }

    protected String getTargetResizeCommandOptions(TransformationOptions options, File sourceFile) {
        if (options == null) {
            return null;
        }
        ImageResizeOptions imageResizeOptions = null;
        if (options instanceof ImageTransformationOptions) {
            imageResizeOptions = ((ImageTransformationOptions)options).getResizeOptions();
        }
        if (options instanceof VideoTransformationOptions) {
            imageResizeOptions = ((VideoTransformationOptions)options).getResizeOptions();
        }
        if (imageResizeOptions == null) {
            return null;
        }
        float aspectRatio = 1.3333f;
        try {
            String sourceDetails = this.getDetails(sourceFile);
            String sourceResolution = this.getResolution(sourceDetails);
            if (sourceResolution != null) {
                Integer sourceWidth = new Integer(sourceResolution.split("x")[0]);
                Integer sourceHeight = new Integer(sourceResolution.split("x")[1]);
                aspectRatio = sourceWidth.floatValue() / sourceHeight.floatValue();
            }
        }
        catch (Exception e) {
            logger.warn((Object)("Could not get file details: " + e.getMessage()));
        }
        StringBuilder builder = new StringBuilder(32);
        int width = imageResizeOptions.getWidth();
        int height = imageResizeOptions.getHeight();
        if (imageResizeOptions.isMaintainAspectRatio()) {
            if (imageResizeOptions.getWidth() > 0 && imageResizeOptions.getHeight() > 0) {
                if (imageResizeOptions.getWidth() <= imageResizeOptions.getHeight()) {
                    width = imageResizeOptions.getWidth();
                    height = Math.round((float)width * (1.0f / aspectRatio));
                } else if (imageResizeOptions.getWidth() > imageResizeOptions.getHeight()) {
                    height = imageResizeOptions.getHeight();
                    width = Math.round((float)height * aspectRatio);
                }
            } else if (!this.isFilterSupported()) {
                if (imageResizeOptions.getHeight() < 0) {
                    width = imageResizeOptions.getWidth();
                    height = Math.round((float)width * (1.0f / aspectRatio));
                } else {
                    height = imageResizeOptions.getHeight();
                    width = Math.round((float)height * aspectRatio);
                }
            }
            if (height > 0 && height % 2 != 0) {
                --height;
            }
            if (width > 0 && width % 2 != 0) {
                ++width;
            }
        }
        if (this.isFilterSupported()) {
            builder.append(CMD_OPT_SCALE);
            builder.append(CMD_OPT_PARAM_ASSIGNMENT);
            builder.append(width);
            builder.append(":");
            builder.append(height);
        } else {
            builder.append(CMD_OPT_SIZE);
            builder.append(" ");
            builder.append(width);
            builder.append("x");
            builder.append(height);
        }
        return builder.toString();
    }

    protected String getFfmpegVideoCodec(String gytheioVideoCodec) {
        if (this.versionDetailsString == null) {
            return null;
        }
        if ("PASSTHROUGH".equals(gytheioVideoCodec)) {
            return "copy";
        }
        if ("h264".equals(gytheioVideoCodec)) {
            return "libx264";
        }
        if ("mpeg4".equals(gytheioVideoCodec)) {
            return "mpeg4";
        }
        if ("theora".equals(gytheioVideoCodec)) {
            return "libtheora";
        }
        if ("vp8".equals(gytheioVideoCodec)) {
            return "libvpx";
        }
        if ("wmv".equals(gytheioVideoCodec)) {
            return null;
        }
        return null;
    }

    protected String getCmdOptVideoBitrate() {
        return this.isVersion1orGreater() ? CMD_OPT_VIDEO_BITRATE_v1 : CMD_OPT_VIDEO_BITRATE_v0;
    }

    protected String getCmdOptVideoCodec() {
        return this.isVersion1orGreater() ? CMD_OPT_VIDEO_CODEC_v1 : CMD_OPT_VIDEO_CODEC_v0;
    }

    protected String getCmdOptAudioBitrate() {
        return this.isVersion1orGreater() ? CMD_OPT_AUDIO_BITRATE_v1 : CMD_OPT_AUDIO_BITRATE_v0;
    }

    protected String getCmdOptAudioCodec() {
        return this.isVersion1orGreater() ? CMD_OPT_AUDIO_CODEC_v1 : CMD_OPT_AUDIO_CODEC_v0;
    }

    protected String getTargetVideoCommandOptions(String sourceMediaType, String targetMediaType, TransformationOptions options) {
        String commandOptions = DEFAULT_VIDEO_PRESET_PREFIX;
        if (options == null || !(options instanceof VideoTransformationOptions)) {
            if (!this.isVersion1orGreater() && targetMediaType.equals(FileMediaType.VIDEO_M4V.getMediaType())) {
                commandOptions = commandOptions.trim() + " " + this.getVideoPresetOptions();
                return commandOptions.trim();
            }
            return null;
        }
        Float frameRate = ((VideoTransformationOptions)options).getTargetVideoFrameRate();
        Long videoBitrate = ((VideoTransformationOptions)options).getTargetVideoBitrate();
        String videoCodec = ((VideoTransformationOptions)options).getTargetVideoCodec();
        if (frameRate != null) {
            commandOptions = commandOptions + CMD_OPT_FRAME_RATE + " " + frameRate;
        }
        if (videoBitrate != null) {
            commandOptions = commandOptions + " " + this.getCmdOptVideoBitrate() + " " + videoBitrate / 1000L + "k";
        }
        if (videoCodec != null) {
            commandOptions = commandOptions.trim() + " " + this.getCmdOptVideoCodec() + " " + this.getFfmpegVideoCodec(videoCodec);
        }
        if (!this.isVersion1orGreater() && (videoCodec != null && videoCodec.equals("h264") || targetMediaType.equals(FileMediaType.VIDEO_M4V.getMediaType()))) {
            commandOptions = commandOptions.trim() + " " + this.getVideoPresetOptions();
        }
        return commandOptions.trim();
    }

    protected String getVideoPresetOptions() {
        String preset = DEFAULT_VIDEO_PRESET;
        if (this.ffmpegPresetsDir != null) {
            preset = this.ffmpegPresetsDir + System.getProperty("file.separator") + DEFAULT_VIDEO_PRESET_PREFIX + DEFAULT_VIDEO_PRESET + DEFAULT_VIDEO_PRESET_SUFFIX;
        }
        return "-vpre " + preset;
    }

    protected String getFfmpegAudioCodec(String targetMediaType, String gytheioAudioCodec) {
        if (this.versionFullDetailsString == null) {
            return null;
        }
        if ("PASSTHROUGH".equals(gytheioAudioCodec)) {
            return "copy";
        }
        if ("aac".equals(gytheioAudioCodec) || targetMediaType.equals(FileMediaType.VIDEO_M4V.getMediaType()) || gytheioAudioCodec == null && targetMediaType.equals(FileMediaType.VIDEO_MP4.getMediaType())) {
            if (this.versionFullDetailsString.contains("libfdk-aac")) {
                return "libfdk_aac";
            }
            if (this.versionFullDetailsString.contains("libfaac")) {
                return "libfaac";
            }
            if (this.versionFullDetailsString.contains("libvo-aacenc")) {
                return "libvo_aacenc";
            }
            return "aac -strict experimental";
        }
        if ("mp3".equals(gytheioAudioCodec)) {
            return "libmp3lame";
        }
        if ("vorbis".equals(gytheioAudioCodec)) {
            return "libvorbis";
        }
        if ("wma".equals(gytheioAudioCodec)) {
            return "wmav2";
        }
        return null;
    }

    protected String getTargetAudioCommandOptions(String targetMediaType, TransformationOptions options) {
        String commandOptions = DEFAULT_VIDEO_PRESET_PREFIX;
        if (options == null) {
            return null;
        }
        if (!(options instanceof AudioTransformationOptions)) {
            return null;
        }
        Long audioBitrate = ((AudioTransformationOptions)options).getTargetAudioBitrate();
        Integer audioSamplingRate = ((AudioTransformationOptions)options).getTargetAudioSamplingRate();
        Integer audioChannels = ((AudioTransformationOptions)options).getTargetAudioChannels();
        String audioCodec = ((AudioTransformationOptions)options).getTargetAudioCodec();
        boolean fastStartEnabled = ((AudioTransformationOptions)options).getTargetFastStartEnabled();
        if (audioBitrate != null) {
            commandOptions = commandOptions + this.getCmdOptAudioBitrate() + " " + audioBitrate / 1000L + "k";
        }
        if (audioSamplingRate != null) {
            commandOptions = commandOptions + " " + CMD_OPT_AUDIO_SAMPLING_RATE + " " + audioSamplingRate;
        }
        if (audioChannels != null) {
            commandOptions = commandOptions.trim() + " " + CMD_OPT_AUDIO_CHANNELS + " " + audioChannels;
        }
        if (audioCodec != null || targetMediaType.equals(FileMediaType.VIDEO_M4V.getMediaType()) || targetMediaType.equals(FileMediaType.VIDEO_MP4.getMediaType())) {
            commandOptions = commandOptions.trim() + " " + this.getCmdOptAudioCodec() + " " + this.getFfmpegAudioCodec(targetMediaType, audioCodec);
        }
        if (fastStartEnabled && this.versionFullDetailsString != null && this.versionFullDetailsString.contains("faststart")) {
            commandOptions = commandOptions.trim() + " " + CMD_OPT_MOV_FLAGS + " " + CMD_OPT_MOV_FLAGS_FASTSTART;
        }
        return commandOptions.trim();
    }

    protected String getComponentExclusionCommandOptions(String sourceMimetype, String targetMimetype) {
        String commandOptions = DEFAULT_VIDEO_PRESET_PREFIX;
        if (this.disableVideo(sourceMimetype, targetMimetype)) {
            commandOptions = commandOptions + CMD_OPT_DISABLE_VIDEO + " ";
        }
        if (this.disableAudio(sourceMimetype, targetMimetype)) {
            commandOptions = commandOptions + CMD_OPT_DISABLE_AUDIO + " ";
        }
        if (this.disableSubtitles(sourceMimetype, targetMimetype)) {
            commandOptions = commandOptions + CMD_OPT_DISABLE_SUBTITLES + " ";
        }
        return commandOptions.trim();
    }

    protected String getFormatCommandOptions(String sourceMimetype, String targetMimetype) {
        if (targetMimetype.startsWith("image/")) {
            return "-f image2";
        }
        if (targetMimetype.equals("audio/ogg")) {
            return "-f ogg";
        }
        return null;
    }

    protected String getSourceTemporalCommandOptions(String sourceMimetype, String targetMimetype, TransformationOptions options) {
        TemporalSourceOptions temporalSourceOptions = null;
        if (options != null) {
            temporalSourceOptions = (TemporalSourceOptions)options.getSourceOptions(TemporalSourceOptions.class);
        }
        String commandOptions = DEFAULT_VIDEO_PRESET_PREFIX;
        if (temporalSourceOptions != null && temporalSourceOptions.getOffset() != null) {
            commandOptions = commandOptions + CMD_OPT_OFFSET + " " + temporalSourceOptions.getOffset() + " ";
        }
        return commandOptions.trim();
    }

    protected String getTargetTemporalCommandOptions(String sourceMimetype, String targetMimetype, TransformationOptions options) {
        TemporalSourceOptions temporalSourceOptions = null;
        if (options != null) {
            temporalSourceOptions = (TemporalSourceOptions)options.getSourceOptions(TemporalSourceOptions.class);
        }
        String commandOptions = DEFAULT_VIDEO_PRESET_PREFIX;
        if (this.isSingleSourceFrameRangeRequired(sourceMimetype, targetMimetype, options)) {
            commandOptions = commandOptions + CMD_OPT_PAIR_1_FRAME + " ";
        } else if (temporalSourceOptions != null && temporalSourceOptions.getDuration() != null) {
            commandOptions = commandOptions + CMD_OPT_DURATION + " " + temporalSourceOptions.getDuration() + " ";
        }
        if (temporalSourceOptions != null && temporalSourceOptions.getElementIntervalSeconds() != null) {
            commandOptions = commandOptions + CMD_OPT_FRAME_RATE_FILTER + CMD_OPT_PARAM_ASSIGNMENT + temporalSourceOptions.getElementIntervalSeconds() + " ";
        }
        return commandOptions.trim();
    }

    protected boolean isSingleSourceFrameRangeRequired(String sourceMimetype, String targetMimetype, TransformationOptions options) {
        if (this.isStoryboardThumbnailRequest(sourceMimetype, targetMimetype, options)) {
            return false;
        }
        return targetMimetype.startsWith("image/");
    }

    protected boolean isStoryboardThumbnailRequest(String sourceMimetype, String targetMimetype, TransformationOptions options) {
        if (!targetMimetype.startsWith("image/") || options == null || !(options instanceof VideoTransformationOptions)) {
            return false;
        }
        TemporalSourceOptions temporalSourceOptions = (TemporalSourceOptions)options.getSourceOptions(TemporalSourceOptions.class);
        return temporalSourceOptions != null && temporalSourceOptions.getElementIntervalSeconds() != null;
    }

    protected boolean disableVideo(String sourceMimetype, String targetMimetype) {
        return targetMimetype.startsWith("audio/");
    }

    protected boolean disableAudio(String sourceMimetype, String targetMimetype) {
        return targetMimetype.startsWith("image/");
    }

    protected boolean disableSubtitles(String sourceMimetype, String targetMimetype) {
        return targetMimetype.startsWith("audio/");
    }

    protected ContentReference createMultiTargetContentReference(String mediaType) {
        String filename = ((Object)((Object)this)).getClass().getSimpleName() + "-target-" + UUID.randomUUID().toString() + CMD_OPT_MULTI_TARGET_INDEX_FORMATTER + "." + FileMediaType.SERVICE.getExtension(mediaType);
        ContentReference multiTarget = this.targetContentReferenceHandler.createContentReference(filename, mediaType);
        this.targetContentReferenceHandler.delete(multiTarget);
        return multiTarget;
    }
}

