/*
 * Decompiled with CFR 0.152.
 */
package org.gytheio.content.transform.ffmpeg;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.Date;
import java.util.Scanner;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.gytheio.content.transform.ContentTransformerWorkerProgressReporter;
import org.gytheio.util.exec.RuntimeExec;

public class FfmpegInputStreamReaderThreadFactory
extends RuntimeExec.InputStreamReaderThreadFactory {
    private static final Log logger = LogFactory.getLog(FfmpegInputStreamReaderThreadFactory.class);
    private static final long PROGRESS_REPORT_FREQUENCY_MS = 2000L;
    protected static final Pattern DURATION_PATTERN = Pattern.compile("(?<=Duration: )[^,]*");
    protected static final Pattern TIME_PATTERN_V0 = Pattern.compile("(?<=time=)[\\d.]*");
    protected static final Pattern TIME_PATTERN_V1 = Pattern.compile("(?<=time=)[\\d:.]*");
    protected ContentTransformerWorkerProgressReporter progressReporter;
    protected boolean isFfmpegVersion1;

    public FfmpegInputStreamReaderThreadFactory(ContentTransformerWorkerProgressReporter progressReporter, boolean isFfmpegVersion1) {
        this.progressReporter = progressReporter;
        this.isFfmpegVersion1 = isFfmpegVersion1;
    }

    public RuntimeExec.InputStreamReaderThread createInstance(InputStream is, Charset charset) {
        return new FfmpegInputStreamReaderThread(is, charset, this.progressReporter, this.isFfmpegVersion1);
    }

    public static class FfmpegInputStreamReaderThread
    extends RuntimeExec.InputStreamReaderThread {
        protected ContentTransformerWorkerProgressReporter progressReporter;
        protected boolean isFfmpegVersion1;
        private Double durationTotalSecs;
        private long lastReportTime = 0L;

        public FfmpegInputStreamReaderThread(InputStream is, Charset charset, ContentTransformerWorkerProgressReporter progressReporter, boolean isFfmpegVersion1) {
            super(is, charset);
            this.progressReporter = progressReporter;
            this.isFfmpegVersion1 = isFfmpegVersion1;
        }

        protected void processBytes(byte[] bytes, int count) throws UnsupportedEncodingException {
            String toWrite = new String(bytes, 0, count, this.charset.name());
            super.addToBuffer(toWrite);
            if (this.progressReporter != null) {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bytes);
                this.read(byteArrayInputStream);
            }
        }

        protected double getTotalSeconds(String timeHHmmss) {
            String[] timeSegments = timeHHmmss.split(":");
            return (double)(Integer.parseInt(timeSegments[0]) * 3600 + Integer.parseInt(timeSegments[1]) * 60) + Double.parseDouble(timeSegments[2]);
        }

        protected void read(InputStream inputStream) {
            String match;
            Pattern timePattern;
            Scanner scanner = new Scanner(inputStream);
            if (this.durationTotalSecs == null) {
                String duration = scanner.findWithinHorizon(DURATION_PATTERN, 0);
                if (duration == null) {
                    scanner.close();
                    return;
                }
                try {
                    this.durationTotalSecs = this.getTotalSeconds(duration);
                }
                catch (Exception e) {
                    logger.debug((Object)("could not get duration for progress reporting from '" + duration + "' with isFfmpegVersions=" + this.isFfmpegVersion1 + ": " + e.getMessage()));
                    scanner.close();
                    return;
                }
            }
            Pattern pattern = timePattern = this.isFfmpegVersion1 ? TIME_PATTERN_V1 : TIME_PATTERN_V0;
            while (null != (match = scanner.findWithinHorizon(timePattern, 0))) {
                long now = new Date().getTime();
                if (now - this.lastReportTime <= 2000L) continue;
                if (match.equals("")) break;
                try {
                    double progressTotalSecs = this.isFfmpegVersion1 ? this.getTotalSeconds(match) : Double.parseDouble(match);
                    float progress = new Double(progressTotalSecs / this.durationTotalSecs).floatValue();
                    if ((double)progress > 1.0) break;
                    this.progressReporter.onTransformationProgress(progress);
                }
                catch (Exception e) {
                    logger.debug((Object)("could not get progress for reporting from'" + match + "' with isFfmpegVersions=" + this.isFfmpegVersion1 + ": " + e.getMessage()));
                }
                this.lastReportTime = new Date().getTime();
            }
            scanner.close();
        }
    }
}

